//
//  Extentions.swift
//  Orbis
//
//  Created by KALSI on 7/10/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class Extentions: NSObject {

}

//MARK:- String -
public extension String{
    
    //MARK: LOCATION
    var timeOfLocationUpdate : String {
        var dateDict = NSDictionary()
        
        if UserDefaults.standard.object(forKey: "locationOrb") != nil {
            dateDict = UserDefaults.standard.object(forKey: "locationOrb") as! NSDictionary
            
            let formatter = DateFormatter()
            formatter.dateFormat = "EE, d LLLL yyyy HH:mm:ss Z"
            let dat = formatter.date(from: dateDict.value(forKey: "date") as! String)
            
            return getIntervalBetweenDates(dateRangeStart: dat)
            
            }else{
            return "No updates"
        }
    }
    
    //MARK: PLACE
    var placeOfLocationUpdate : String {
        var dateDict = NSDictionary()
        if UserDefaults.standard.object(forKey: "locationOrb") != nil{
            dateDict = UserDefaults.standard.object(forKey: "locationOrb") as! NSDictionary
            return (dateDict.value(forKey: "location") as? String)!
        }else{
            return "No updates"
        }
    }
    
    //Last time Amber call
    var timeOfLastAmberCall : String {
        
        if UserDefaults.standard.object(forKey: "lastAmberCall") != nil {
            let lastDate = UserDefaults.standard.object(forKey: "lastAmberCall") as! String
            
            let formatter = DateFormatter()
            formatter.dateFormat = "EE, d LLLL yyyy HH:mm:ss Z"
            let dat = formatter.date(from: lastDate)
            
            return getIntervalBetweenDates(dateRangeStart: dat)
            
        }else{
            return "No updates"
        }
    }
    
    //GET Formatted current Time
    var fullFormatCurrentTime : String {
        let formatter = DateFormatter()
        formatter.dateFormat = "EE, d LLLL yyyy HH:mm:ss Z"
        return formatter.string(from: Date())
    }
    
}

func getIntervalBetweenDates(dateRangeStart : Date?) -> String{
    
    let dateRangeEnd = Date()
    let components = Calendar.current.dateComponents([.year, .month, .day, .hour, .minute, .second], from: dateRangeStart!, to: dateRangeEnd)
    
    _ = components.year ?? -1
    let month = components.month ?? -1
    let day = components.day ?? -1
    let hour = components.hour ?? -1
    let minute = components.minute ?? -1
    let second = components.second ?? -1
    
    if month != -1 && month < 12 && month != 0{
        if day != -1 && day < 30{
            return "\(month) months & \(day) days ago"
        }else{
            return "\(month) months ago"
        }
    }else if day != -1 && day < 30 && day != 0{
        if hour != -1 && hour < 24{
            return "\(day) days & \(hour) hrs ago"
        }else{
            return "\(day) days ago"
        }
    }else if hour != -1 && hour < 24 && hour != 0{
        if minute != -1 && minute < 60{
            return "\(hour) hrs & \(minute) mins ago"
        }else{
            return "\(hour) hrs ago"
        }
    }else if minute != -1 && minute < 60 && minute != 0{
        if second != -1 && second < 60{
            return "\(minute) mins & \(second) secs ago"
        }else{
            return "\(minute) mins ago"
        }
    }else if second != -1 && second < 60 && second != 0{
        return "\(second) secs ago"
    }else if second == 0{
        return "\(second) secs ago"
    }else{
        return "No updates"
    }
}

//MARK:- UIDevice -
public extension UIDevice {
    
    var modelName: String {
        var systemInfo = utsname()
        uname(&systemInfo)
        let machineMirror = Mirror(reflecting: systemInfo.machine)
        let identifier = machineMirror.children.reduce("") { identifier, element in
            guard let value = element.value as? Int8 , value != 0 else { return identifier }
            return identifier + String(UnicodeScalar(UInt8(value)))
        }
        
        switch identifier {
        case "iPod5,1":
            return "iPod Touch 5"
        case "iPod7,1":
            return "iPod Touch 6"
        case "iPhone3,1", "iPhone3,2", "iPhone3,3":
            return "iPhone 4"
        case "iPhone4,1":
            return "iPhone 4s"
        case "iPhone5,1", "iPhone5,2":
            return "iPhone 5"
        case "iPhone5,3", "iPhone5,4":
            return "iPhone 5c"
        case "iPhone6,1", "iPhone6,2":
            return "iPhone 5s"
        case "iPhone7,2":
            return "iPhone 6"
        case "iPhone7,1":
            return "iPhone 6 Plus"
        case "iPhone8,1":
            return "iPhone 6s"
        case "iPhone8,2":
            return "iPhone 6s Plus"
        case "iPad2,1", "iPad2,2", "iPad2,3", "iPad2,4":
            return "iPad 2"
        case "iPad3,1", "iPad3,2", "iPad3,3":
            return "iPad 3"
        case "iPad3,4", "iPad3,5", "iPad3,6":
            return "iPad 4"
        case "iPad4,1", "iPad4,2", "iPad4,3":
            return "iPad Air"
        case "iPad5,3", "iPad5,4":
            return "iPad Air 2"
        case "iPad2,5", "iPad2,6", "iPad2,7":
            return "iPad Mini"
        case "iPad4,4", "iPad4,5", "iPad4,6":
            return "iPad Mini 2"
        case "iPad4,7", "iPad4,8", "iPad4,9":
            return "iPad Mini 3"
        case "iPad5,1", "iPad5,2":
            return "iPad Mini 4"
        case "iPad6,7", "iPad6,8":
            return "iPad Pro"
        case "AppleTV5,3":
            return "Apple TV"
        case "i386", "x86_64":
            return "Simulator"
        default:
            return identifier
        }
    }
}


//MARK:- Dateextension -

extension Date {
    func toString(format: String) -> String {
        
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "ddMMyyHHmmss"

        
        
//        let dateFormatter1 = DateFormatter()
//        dateFormatter1.dateFormat = "h:mm a"
//
//        let dateFormatter = DateFormatter()
//        dateFormatter.dateFormat = format
        return dateFormatter.string(from: self)
    }
}

extension NSDictionary {
    func generateString() -> String {
//       let allkeys = self.allKeys
//        let allvalues = self.allValues
       // let post_paramsValue = self as! Dictionary<String,String>
        let sortArray = ["datetime","imei","number","messageType","lat","long","posdatatime","postype","status","interval","speed"]

        
//        let sortedKeysAndValues = sortArray(post_paramsValue).sort({ $0.0 < $1.0 })
//        print(sortedKeysAndValues)
               var textString = "PRT,"

        for (index, element) in sortArray.enumerated() {
            if index == sortArray.count-1{
                textString.append("\(self.value(forKey: element)!)")

            }
            else{
            textString.append("\(self.value(forKey: element)!),")
            }
        }
//        print(allkeys)
//        var textString = "PRT,"
//        for (_,value) in self {
//                textString.append("\(self.value(forKey: <#T##String#>)),")
//        }
        return textString
    }
    
    func generateStringTrigger() -> String {
        //       let allkeys = self.allKeys
        //        let allvalues = self.allValues
        // let post_paramsValue = self as! Dictionary<String,String>
        let sortArray = ["datetime","imei","number","messageType","lat","long","posdatatime","postype","status","interval","speed","trigger_from"]
        
        
        //        let sortedKeysAndValues = sortArray(post_paramsValue).sort({ $0.0 < $1.0 })
        //        print(sortedKeysAndValues)
        var textString = "PRT,"
        
        for (index, element) in sortArray.enumerated() {
            if index == sortArray.count-1{
                textString.append("\(self.value(forKey: element)!)")
                
            }
            else{
                textString.append("\(self.value(forKey: element)!),")
            }
        }
        //        print(allkeys)
        //        var textString = "PRT,"
        //        for (_,value) in self {
        //                textString.append("\(self.value(forKey: <#T##String#>)),")
        //        }
        return textString
    }

    
}
